/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.client.PIHSCCECClient;
import com.ibm.hsc.command.PIHMCCommandUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class PIProfileDataRestore {
    private static final int NUM_VALID_PARMS = 3;
    private static final String DEFAULT_RESTORE_FILE_PATH = "/var/hsc/profiles/";
    private String m_fileName;
    private String m_managedSystem;
    private String m_restoreType;
    private String mtms;
    private String serialNumber;
    private String newFileName;
    private short restoreTypeShort;
    private HashMap m_validParms = new HashMap(7, 0.5f);
    private PIHSCCECClient m_CECClient = null;
    private PrintStream m_out;
    private boolean m_writeStatus;

    private PIProfileDataRestore(PIHSCCECClient pIHSCCECClient, PrintStream printStream, boolean bl) {
        this.m_CECClient = pIHSCCECClient;
        this.m_out = printStream;
        this.m_writeStatus = bl;
        this.m_validParms.put("-f", null);
        this.m_validParms.put("-m", null);
        this.m_validParms.put("-l", null);
        this.mtms = this.m_CECClient.getIntName();
        this.serialNumber = this.mtms.substring(this.mtms.indexOf("*") + 1, this.mtms.length());
        System.out.println("in  PIProfileDataRestore constructor : serialNumber = " + this.serialNumber);
    }

    private void performCommand() throws PIHscClientException {
        Vector<String> vector = new Vector<String>();
        this.checkParameters();
        vector.add(this.newFileName);
        this.restoreTypeShort = new Short(this.m_restoreType);
        this.m_CECClient.profileDataOps(this.restoreTypeShort, vector);
        if (this.m_writeStatus) {
            this.m_writeStatus = false;
            this.m_out.print('\u0000');
        }
    }

    private void checkParameters() throws PIHscClientException {
        short s;
        String string = "";
        if (null == this.m_managedSystem || this.m_managedSystem.length() == 0) {
            string = string + "-m";
        }
        if (null == this.m_restoreType || this.m_restoreType.length() == 0) {
            if (string.length() != 0) {
                string = string + ", ";
            }
            string = string + "-l";
        }
        if (string.length() > 0) {
            String[] stringArray = new String[]{string};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        try {
            s = Short.parseShort(this.m_restoreType);
        }
        catch (NumberFormatException numberFormatException) {
            String[] stringArray = new String[]{"-l"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        if (s == 4) {
            this.m_restoreType = new Short(5).toString();
            if (null != this.m_fileName) {
                String[] stringArray = new String[]{"-f"};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM", stringArray, null);
            }
        } else if (s == 1 || s == 3 || s == 2) {
            if (null == this.m_fileName) {
                String[] stringArray = new String[]{"-f"};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
            }
        } else {
            String[] stringArray = new String[]{"-l"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        File file = null;
        String string2 = null;
        if (this.m_fileName != null) {
            string2 = this.m_fileName.indexOf("/") == -1 ? this.m_fileName : this.m_fileName.substring(this.m_fileName.lastIndexOf("/") + 1, this.m_fileName.length());
            this.newFileName = DEFAULT_RESTORE_FILE_PATH + this.serialNumber + "/" + string2;
            System.out.println("newFileName = " + this.newFileName);
            file = new File(this.newFileName);
            if (!file.exists()) {
                this.newFileName = DEFAULT_RESTORE_FILE_PATH + this.mtms + "/" + string2;
                file = new File(this.newFileName);
                if (!file.exists()) {
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "CANNOT_FIND_FILE_ERROR", null, null);
                }
            }
            if (!file.exists()) {
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "CANNOT_FIND_FILE_ERROR", null, null);
            }
        }
    }

    private void mapParameters(HashMap hashMap) {
        this.m_fileName = (String)hashMap.get("-f");
        this.m_managedSystem = (String)hashMap.get("-m");
        this.m_restoreType = (String)hashMap.get("-l");
    }

    public static void printHelp(PrintStream printStream, boolean bl) {
        if (bl) {
            printStream.print('\u0000');
        }
        printStream.println(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "RSTPROFDATA_HELP_2"));
    }

    public static int callCommandFromRouter(PIHSCCECClient pIHSCCECClient, String[] stringArray, PrintStream printStream, boolean bl) {
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        PIProfileDataRestore pIProfileDataRestore = new PIProfileDataRestore(pIHSCCECClient, printStream, bl);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
            HashMap hashMap = PIHMCCommandUtils.parseParameters(arrayList, pIProfileDataRestore.m_validParms);
            pIProfileDataRestore.mapParameters(hashMap);
            pIProfileDataRestore.performCommand();
        }
        catch (PIHscClientException pIHscClientException) {
            if (bl) {
                bl = false;
                printStream.print('\u0001');
            }
            pIHscClientException.printStackTrace(System.out);
            if ("8000".equals(pIHscClientException.getHscExId())) {
                printStream.println(pIHscClientException.getMessage());
            } else {
                String string = pIHscClientException.getMessage();
                if (string == null || string.length() == 0) {
                    string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
                }
                printStream.println(string);
            }
            n = 1;
        }
        catch (Exception exception) {
            if (bl) {
                bl = false;
                printStream.print('\u0001');
            }
            exception.printStackTrace(System.out);
            String string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "COMMAND_LINE_ERROR");
            printStream.println(string);
            n = 1;
        }
        return n;
    }
}

